BEGIN;

-- vytvoř minimalni prázdné struktury tabulek, aby mohly byt spusteny obecné SQL dotazy pro naplneni
-- i pro vykres s jednim prvkem
CREATE TABLE if not exists Tech_B    (nazev VARCHAR(255), jev VARCHAR(3), popis VARCHAR(3), ISPD_hl VARCHAR(3), ObjCode VARCHAR(32));
CREATE TABLE if not exists Tech_L    (nazev VARCHAR(255), jev VARCHAR(3), popis VARCHAR(3), ISPD_hl VARCHAR(3), ObjCode VARCHAR(32));
CREATE TABLE if not exists Tech_P    (nazev VARCHAR(255), jev VARCHAR(3), popis VARCHAR(3), ISPD_hl VARCHAR(3), ObjCode VARCHAR(32));
CREATE TABLE if not exists Kolej_B   (nazev VARCHAR(255), jev VARCHAR(3), popis VARCHAR(3), ISPD_hl VARCHAR(3), ObjCode VARCHAR(32));
CREATE TABLE if not exists Kolej_L   (nazev VARCHAR(255), jev VARCHAR(3), popis VARCHAR(3), ISPD_hl VARCHAR(3), ObjCode VARCHAR(32));
CREATE TABLE if not exists Kolej_P   (nazev VARCHAR(255), jev VARCHAR(3), popis VARCHAR(3), ISPD_hl VARCHAR(3), ObjCode VARCHAR(32));
CREATE TABLE if not exists NavestidB (nazev VARCHAR(255), jev VARCHAR(3), popis VARCHAR(3), ISPD_hl VARCHAR(3), ObjCode VARCHAR(32));
CREATE TABLE if not exists NavestidL (nazev VARCHAR(255), jev VARCHAR(3), popis VARCHAR(3), ISPD_hl VARCHAR(3), ObjCode VARCHAR(32));

CREATE UNIQUE INDEX CodeToISPDidx ON CodeToISPD (ObjCode);

-- vypln výchozi hodnoty pokud nejsou u objektu vyplneny
-- JEV
UPDATE Tech_B    SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.jev IS NULL;
UPDATE Tech_L    SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.jev IS NULL;
UPDATE Tech_P    SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.jev IS NULL;
UPDATE Kolej_B   SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.jev IS NULL;
UPDATE Kolej_L   SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.jev IS NULL;
UPDATE Kolej_P   SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.jev IS NULL;
UPDATE NavestidB SET jev = (SELECT jev FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.jev IS NULL;
UPDATE NavestidL SET jev = (SELECT jev FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.jev IS NULL;

-- ISPD_hl
UPDATE Tech_B    SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.ISPD_hl IS NULL;
UPDATE Tech_L    SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.ISPD_hl IS NULL;
UPDATE Tech_P    SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.ISPD_hl IS NULL;
UPDATE Kolej_B   SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.ISPD_hl IS NULL;
UPDATE Kolej_L   SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.ISPD_hl IS NULL;
UPDATE Kolej_P   SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.ISPD_hl IS NULL;
UPDATE NavestidB SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.ISPD_hl IS NULL;
UPDATE NavestidL SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.ISPD_hl IS NULL;

-- popis
UPDATE Tech_B    SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.popis IS NULL;
UPDATE Tech_L    SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.popis IS NULL;
UPDATE Tech_P    SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.popis IS NULL;
UPDATE Kolej_B   SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.popis IS NULL;
UPDATE Kolej_L   SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.popis IS NULL;
UPDATE Kolej_P   SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.popis IS NULL;
UPDATE NavestidB SET popis = (SELECT popis FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.popis IS NULL;
UPDATE NavestidL SET popis = (SELECT popis FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.popis IS NULL;

-- rozchod
UPDATE Kolej_B   SET rozchod = (SELECT rozchod FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.rozchod IS NULL;
UPDATE Kolej_L   SET rozchod = (SELECT rozchod FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.rozchod IS NULL;
UPDATE Kolej_P   SET rozchod = (SELECT rozchod FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.rozchod IS NULL;

-- KV
UPDATE Kolej_B   SET KV = (SELECT KV FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.KV IS NULL;
UPDATE Kolej_L   SET KV = (SELECT KV FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.KV IS NULL;
UPDATE Kolej_P   SET KV = (SELECT KV FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.KV IS NULL;

-- plocha
UPDATE Kolej_B   SET plocha = (SELECT plocha FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.plocha IS NULL;
UPDATE Kolej_L   SET plocha = (SELECT plocha FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.plocha IS NULL;
UPDATE Kolej_P   SET plocha = (SELECT plocha FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.plocha IS NULL;


-- nazev
UPDATE Tech_B    SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.nazev IS NULL;
UPDATE Tech_L    SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.nazev IS NULL;
UPDATE Tech_P    SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.nazev IS NULL;
UPDATE Kolej_B   SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.nazev IS NULL;
UPDATE Kolej_L   SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.nazev IS NULL;
UPDATE Kolej_P   SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.nazev IS NULL;
UPDATE NavestidB SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.nazev IS NULL;
UPDATE NavestidL SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.nazev IS NULL;

COMMIT;